#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Light in the DarkMod01.fsh   by   RogerB 
//https://www.shadertoy.com/view/7s2SRz
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int       iFrame;
#define iTime u_Elapsed*0.177  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Raymarcher adapted from implementation by Inigo Quilez

#define GAMMA_CORRECTION
#define MOTION
#define DISTANCE_FOG

// Material aliases
#define WATER 0
#define LAMBERT_RED 1
#define BLOB 2

// Scene compositions.
//#define COMPOSITION_0
//#define COMPOSITION_1
#define COMPOSITION_2

// Camera Views
//#define VIEW_0
#define VIEW_1
//#define MOUSE_CONTROL

// Water Noise (NO NOISE -> 0, PERLIN -> 1, WORLEY -> 2, IQ -> 3)
// Iq noise taken from https://www.shadertoy.com/view/4sS3zG.
#define NOISE 1
#define SINEWAVES

const float INFINITY = 99999999999999999.99f;
const float PI = 3.14159;
const float EPSILON = 0.0001f;
const float MIN_CLIP = 0.001f;
const float FAR_CLIP = 500.f;
const int RAY_STEPS = 256;
const int SHADOW_RAY_STEPS = 256;

vec2 random2(vec2 p, float seed) {
    return fract(sin(vec2(dot(p, vec2(127.1, 311.7)),
                 dot(p, vec2(269.5,183.3))))
                 * seed);
}

float noise2D(vec2 p, float seed){
    p /= 20.f;
    return fract(5.f * sin(dot(p, p) * seed) - p.y * cos(435.324 * seed * p.x));;
}

float worley(vec2 uv, float seed) {
    uv *= 10.0; // Now the space is 10x10 instead of 1x1. Change this to any number you want.
    vec2 uvInt = floor(uv);
    vec2 uvFract = fract(uv);
    float minDist = 1.0; // Minimum distance initialized to max.
    for(int y = -1; y <= 1; ++y) {
        for(int x = -1; x <= 1; ++x) {
            vec2 neighbor = vec2(float(x), float(y)); // Direction in which neighbor cell lies
            vec2 point = random2(uvInt + neighbor, seed); // Get the Voronoi centerpoint for the neighboring cell
            vec2 diff = neighbor + point - uvFract; // Distance between fragment coord and neighbor’s Voronoi point
            float dist = length(diff);
            minDist = min(minDist, dist);
        }
    }
    return minDist;
}

vec3 random3( vec3 p ) {
    return fract(sin(vec3(dot(p,vec3(127.1, 311.7, 191.999)),
                          dot(p,vec3(269.5, 183.3, 765.54)),
                          dot(p, vec3(420.69, 631.2,109.21))))
                 *43758.5453);
}

float noise3( vec3 p ) {
    vec3 noise = fract(sin(vec3(dot(p,vec3(127.1, 311.7, 191.999)),
                          dot(p,vec3(269.5, 183.3, 765.54)),
                          dot(p, vec3(420.69, 631.2,109.21))))
                 *43758.5453);
    return max(noise.x, max(noise.y, noise.z));
}


float surflet(vec3 p, vec3 gridPoint) {
    // Compute the distance between p and the grid point along each axis, and warp it with a
    // quintic function so we can smooth our cells
    vec3 t2 = abs(p - gridPoint);
    vec3 t = vec3(1.f) - 6.f * pow(t2, vec3(5.f)) + 15.f * pow(t2, vec3(4.f)) - 10.f * pow(t2, vec3(3.f));
    // Get the random vector for the grid point (assume we wrote a function random2
    // that returns a vec2 in the range [0, 1])
    vec3 gradient = random3(gridPoint).xyz * 2.f - vec3(1., 1., 1.);
    // Get the vector from the grid point to P
    vec3 diff = p - gridPoint;
    // Get the value of our height field by dotting grid->P with our gradient
    float height = dot(diff, gradient);
    // Scale our height field (i.e. reduce it) by our polynomial falloff function
    return height * t.x * t.y * t.z;
}

float perlinNoise3D(vec3 p) {
    float surfletSum = 0.f;
    // Iterate over the four integer corners surrounding uv
    for(int dx = 0; dx <= 1; ++dx) {
        for(int dy = 0; dy <= 1; ++dy) {
            for(int dz = 0; dz <= 1; ++dz) {
                surfletSum += surflet(p, floor(p) + vec3(dx, dy, dz));
            }
        }
    }
    return surfletSum;
}

	
float hash(vec2 p)
{
    p  = 50.0*fract( p*0.3183099);
    return fract( p.x*p.y*(p.x+p.y) );
}

float iqNoise( in vec2 p )
{
    vec2 i = floor( p );
    vec2 f = fract( p );
	
	vec2 u = f*f*(3.0-2.0*f);

    return -1.0+2.0*mix( mix( hash( i + vec2(0.0,0.0) ), 
                              hash( i + vec2(1.0,0.0) ), u.x),
                         mix( hash( i + vec2(0.0,1.0) ), 
                              hash( i + vec2(1.0,1.0) ), u.x), u.y);
}

const mat2 m2 = mat2( 0.80, -0.60, 0.60, 0.80 );

float almostIdentity( float x, float m, float n )
{
    if( x>m ) return x;
    float a = 2.0*n - m;
    float b = 2.0*m - 3.0*n;
    float t = x/m;
    return (a*t + b)*t*t + n;
}

float almostAbs( float x )
{
    return almostIdentity(abs(x), 0.05, 0.025 );
}

float iqNoiseLayered( vec2 p )
{
    vec2 q = 0.05*p;
	float f = 0.0;
    f += 0.50000*almostAbs(iqNoise( q )); q = m2*q*2.02; q -= 0.1*iTime;
    f += 0.25000*almostAbs(iqNoise( q )); q = m2*q*2.03; q += 0.2*iTime;
    f += 0.12500*almostAbs(iqNoise( q )); q = m2*q*2.01; q -= 0.4*iTime;
    f += 0.06250*almostAbs(iqNoise( q )); q = m2*q*2.02; q += 1.0*iTime;
    f += 0.03125*almostAbs(iqNoise( q ));
    return 3.7-4.0*f;
}

bool equals(float a, float b){
    return abs(a - b) < EPSILON;
}

bool equalsmargin(float a, float b, float m){
    return abs(a - b) < m;
}

vec2 smin(float a, float b, float k){
    float h = max( k-abs(a-b), 0.0 )/k;
    float m = h*h*h*0.5;
    float s = m*k*(1.0/3.0); 
    return (a<b) ? vec2(a-s,m) : vec2(b-s,1.0-m);
}

// Because the above implementation of smin doesn't work with k=0.
vec2 hardMin(float a, float b) {
    return (a<b) ? vec2(a, 0) : vec2(b, 1);
}

float isect( float d1, float d2, float k ) {
    // float h = clamp( 0.5 - 0.5*(d2-d1)/k, 0.0, 1.0 );
    // return mix( d2, d1, h ) + k*h*(1.0-h); 
    return -smin(-d1, -d2, k).x;
}

float sub(float d1, float d2, float k) {
    return isect(d1, -d2, k);
}

vec3 repeat(vec3 pos, float cx, float cy, float cz){
    return vec3(mod(pos.x + 0.5f * cx, cx) - 0.5f * cx,
                mod(pos.y + 0.5f * cy, cy) - 0.5f * cy,
                mod(pos.z + 0.5f * cz, cz) - 0.5f * cz);
}

vec3 rotateY(vec3 p, float a) {
    return vec3(cos(a) * p.x + sin(a) * p.z, p.y, -sin(a) * p.x + cos(a) * p.z);
}

void computeray (vec3 eye, vec3 ref, vec2 ndc, float fov, out vec3 ro, out vec3 rd)
{
    vec3 look = ref - eye;
    
    float len = tan(fov * PI/180.f) * distance(eye, ref);
    
    vec3 v, h;
    h = normalize(cross(vec3(0.0, 1.0, 0.0), ref - eye));
    v = normalize(cross(h, look));;

    h *= len * iResolution.x/iResolution.y;
    v *= len;
    
    vec3 p = ref + ndc.x * h + ndc.y * v;
            
    p = ref + ndc.x * h + ndc.y * v;
        
    ro = eye;
    rd = normalize(p - eye);
}

float infinite_plane_sdf(vec3 pos, float y){
    return pos.y - y;
}

float sphere_sdf (vec3 ro, vec3 p, float r){
    return length(ro - p) - r;
}

float box_sdf(vec3 ro, vec3 p, vec3 b, float r)
{
    vec3 q = abs(ro - p) - b;
    return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0) - r;
}

float cylinder_sdf(vec3 ro, vec3 p, float ra, float rb, float h )
{
  vec2 d = vec2( length(ro.xz - p.xz)-2.0*ra+rb, abs(ro.y - p.y) - h );
  return min(max(d.x,d.y),0.0) + length(max(d,0.0)) - rb;
}

float vert_cylinder_sdf(vec3 ro, vec3 p, float r, float h){
    float s0 = box_sdf(ro, vec3(0.f, 1.f, 0.f) + p, vec3(r, 2.f * r, h), 0.1f);
    float s1 = sphere_sdf(ro, vec3(0.f, 0.f, 0.f) + p, r);
    return isect(s0, s1, 0.1f);

}

float arch_sdf(vec3 ro, vec3 p, float r1, float r2, float t){
    float s0 = vert_cylinder_sdf(ro, p, r1, t);
    float s1 = vert_cylinder_sdf(ro, p, r2, 2.f * t);
    float d1 = sub(s0, s1, 0.1f);
    return d1;
}

float steps_sdf(vec3 ro, vec3 p, vec3 dim, int steps, int axis, int dir){
    float d = INFINITY;
    for (int i = 0; i < steps; i++){
        float cur_step;
        if (axis == 0){
            cur_step = box_sdf(ro, vec3(dim.z * float(i) * float(dir) * 0.8f, 2.f * dim.y * float(i), 0.f) + p, dim, 0.1f);
        } else if (axis == 1){
            cur_step = box_sdf(ro, vec3(0.f, 2.f * dim.y * float(i), dim.x * float(i) * float(dir) * 0.8f) + p, dim.zyx, 0.1f);
        }
        d = min(cur_step, d);
    }
    return d;
}

float full_steps_sdf(vec3 ro, vec3 p, vec3 dim, int steps, int axis, int dir){
    float d = INFINITY;
    for (int i = 1; i < steps; i++){
        float cur_step;
        if (axis == 0){
            cur_step = box_sdf(ro, vec3(dim.z * float(i) * float(dir), dim.y * float(i), 0.f) + p, vec3(dim.x, 2.f * float(i) * dim.y, dim.z), 0.1f);
        } else if (axis == 1){
            cur_step = box_sdf(ro, vec3(0.f, 2.f * dim.y * float(i), dim.x * float(i) * float(dir)) + p, vec3(dim.z, dim.y, dim.x), 0.1f);
        }
        d = min(cur_step, d);
    }
    return d;
}

vec3 map(vec3 p){
    float aTime = iTime/2.f;
    
    //BRIDGE
    vec3 q = repeat(p, 12.f , 0.f, 0.f);
    float a0 = arch_sdf(q, vec3(0.f), 7.f, 5.f, 2.f);
    float a1 = arch_sdf(q, vec3(0.f), 8.f, 6.f, 1.5f);
    float d0 = sub(a0, a1, 0.2f);
    
    
    // FLOATING BLOBS
    vec3 qs1 = repeat(p, 40.f, 0.f, 40.f);
    vec3 qs2 = repeat(p, 10.f, 0.f, 10.f);
    float f = 5.f;
    float hf = 15.5f * cos(p.z/40.f);
    vec3 h0 = vec3(f * cos(iTime/4.f), 15.f + (sin(p.x) + cos(p.z)) * sin(iTime) - hf * (sin(p.x/20.f) + cos(p.z/20.f)) * cos(iTime), f * sin(iTime/2.f));
    vec3 h1 = vec3(5.f + -f * cos(iTime/4.f), 20.f + (sin(p.x) + cos(p.z)) * sin(iTime) + hf * (cos(p.x/20.f) + sin(p.z/20.f)) * sin(iTime), 5.f + -f * sin(iTime/2.f));
    float s0 = sphere_sdf(qs1, h0, 3.5f);
    float s1 = sphere_sdf(qs1, h1, 3.5f);
    float d1 = smin(s0 * 0.5f, s1 * 0.5f, 2.f).x;
    
    
    // WATER
    float plane_noise = 2.f;
    #ifdef SINEWAVES
    plane_noise += 1.f *(cos(p.x/10.f - cos(iTime)) + sin(p.z/15.f + sin(iTime))) * ((sin(iTime/5.f) + 1.1f)*0.5);
    plane_noise -= 1.;
    #endif
    
    #if NOISE == 0
    // nop
    #elif NOISE == 1
    // plane_noise += (perlinNoise3D(p) * (sin(iTime/5.f) + 1.1f) * 0.5f);
    // plane_noise += (perlinNoise3D(p) *  0.2f);
    // plane_noise += (perlinNoise3D(p) * (sin(iTime/5.f) + 1.1f) * 0.1f);
    // plane_noise += perlinNoise3D(vec3(p.x, 0., p.z)) * (sin(iTime/5.f) + 1.1f) * 0.1f; // 2D perlin noise is about 3x as fast to march through, but doesn't look as good.
    // plane_noise += perlinNoise3D(vec3(p.x, iTime, p.z)) * (sin(iTime/5.f) + 1.1f) * 0.1f; // Using the time as the third component makes it look better, while still being 2D noise within a single frame so we keep the performance benefits. At least, we should but we don't for some reason.
    // Shifting the noise over time is both fast and looks alright, however.
    vec3 qWater = p + vec3(-iTime*3., 0., sin(iTime/(1.62*3.))*5.);
    plane_noise += perlinNoise3D(vec3(qWater.x, 0., qWater.z)) * (sin(iTime/5.f) + 1.1f) * 0.1f;
    #elif NOISE == 2
    plane_noise += ((worley(p.xz/10.f, abs(sin(iTime) * cos(iTime/2.f)))) * (sin(iTime/5.f) + 1.1f) * 0.3f);
    #elif NOISE == 3
    // plane_noise += iqNoiseLayered(p.xz) * (sin(iTime/5.f) + 1.1f) * 0.5f;
    plane_noise += iqNoiseLayered(p.xz) * 0.2f;
    #endif
    
    float d2 = infinite_plane_sdf(p, plane_noise);
    
    
    // COMPOSITION
    // x: distance, y: material, z: water mask. (Water mask is used for mixing in the reflection term.)
    vec3 res;
    
    #ifdef COMPOSITION_0
    // In this block, water and blobs merge and the bridge is independent.
    res.xz = smin(d1, d2, 3.f);
    res.y = res.z < 1. ? float(BLOB) : float(WATER);

    vec2 bridge_res;
    bridge_res = hardMin(res.x, d0);
    res.x = bridge_res.x;
    res.y = bool(bridge_res.y) ? float(LAMBERT_RED) : res.y;
    res.z = bool(bridge_res.y) ? 0. : res.z;
    #endif
    
    #ifdef COMPOSITION_1
    // In this block, blobs and the bridge merge with the water but not eachother.
    vec3 bridge_water;
    bridge_water.xz = smin(d0, d2, 1.);
    bridge_water.y = float(LAMBERT_RED);
    
    vec3 blob_water;
    blob_water.xz = smin(d1, d2, 3.);
    blob_water.y = float(BLOB);
    
    res = bridge_water.x < blob_water.x ? bridge_water : blob_water;
    res.y = res.z < 1. ? res.y : float(WATER); // For when water reflects into more water.
    #endif
    
    #ifdef COMPOSITION_2
    // Same as composition 1 but the blobs deform around the bridge.
    vec3 bridge_water;
    bridge_water.xz = smin(d0, d2, 1.);
    bridge_water.y = float(LAMBERT_RED);
    
    float expanded_bridge = d0 - 1.;
    float blob = d1;
    //blob = smin(blob, expanded_bridge, 10.).x; // Make the far side of the blob smush away from the bridge; disabled because of artefacts where the bridge is close to the water.
    blob = sub(blob, expanded_bridge, 2.); // Avoid the bridge instead of going through it.
    
    vec3 blob_water;
    blob_water.xz = smin(blob, d2, 3.);
    blob_water.y = float(BLOB);
    
    res = bridge_water.x < blob_water.x ? bridge_water : blob_water;
    res.y = res.z < 1. ? res.y : float(WATER); // For when water reflects into more water.
    #endif
    
    // TODO: add ability to smoothly blend all three materials, then make a scene that does that.
    
    return res;
}

vec3 calcNormal(in vec3 pos, float eps){
    // Central differences approach.
    // 6s compile time because of over-eager compiler inlining.
    /*
    vec2 e = vec2(eps, 0.f);
    return normalize(vec3(map(pos + e.xyy).x - map(pos - e.xyy).x,
                          map(pos + e.yxy).x - map(pos - e.yxy).x,
                          map(pos + e.yyx).x - map(pos - e.yyx).x));
    */
    
    
    // Tetrahedron approach from https://iquilezles.org/articles/normalsSDF.
    vec3 n = vec3(0.0);
    for(int i=min(iFrame,0); i<4; i++) {
        vec3 e = 0.5773*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        n += e*map(pos+eps*e).x;
    }
    return normalize(n);
    
    
    // Below this point are implementations of inlining-resistant central difference algorithms.
    // I started messing with them because the tetahedron approach was causing black artefacts
    // on the underside bridge corners. (But it turns out I had just accidentally set epsilon an
    // order of magnitude higher than intended in one of the calls.)
    // The below implementations aren't used any more, but I think they're interesting enough to keep.
    
    
    // Inlining-resistant central differences.
    // 3s compile time because two map calls get inlined.
    // Follows the sprit of the inlining-resistant tertrahedron approach, but I haven't seen this implementation elsewhere.
    /*
    vec3 n = vec3(0.0);
    for(int i=min(iFrame,0); i<3; i++) {
        vec3 e = vec3(((i+3)>>1)&1,(i>>1)&1,i&1);
        n += e*map(pos+eps*e).x - e*map(pos-eps*e).x;
    }
    return normalize(n);
    */


    // Inlining-resistant central differences mk. 2.
    // 2s compile time with the single inlined map call.
    // This should be equivalent to mk. 1, but it isn't. (I notice it as banding in the water reflection in the smooth part of the water cycle.) I'm not currently sure why.
    /*
    vec3 n = vec3(0.0);
    for(int i=min(iFrame,0); i<6; i++) {
        float signBit = float(i&1);
        int j = i >> 1;
        vec3 e = signBit * vec3(((j+3)>>1)&1,(j>>1)&1,j&1);
        n += e*map(pos+eps*e).x;
    }
    return normalize(n);
    */
    
    
    // It's worth noting that the central differences approaches aren't much more expensive at runtime than the tetrahedron approach.
    // (Not a lot of the total time is spent calculating normals.)
}

vec3 grad(vec3 pos, float eps) {
    vec3 n = vec3(0.0);
    for(int i=min(iFrame,0); i<4; i++) {
        vec3 e = 0.5773*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        n += e*map(pos+eps*e).x;
    }
    return n;
}

float shadowcast_pointlight(in vec3 ro, in vec3 rd, in float light_dist){
    float res = 1.f;
    float t = MIN_CLIP;
    light_dist = min(light_dist, FAR_CLIP);
    for (int i = 0; i < SHADOW_RAY_STEPS; i++){
        t = min(t, light_dist);
        vec3 pos = ro + rd * t;
        float sdf = map(pos).x;
        // Soft shadows were causing heavy banding on the blobs from the point light sources.
        // The reason was that the "distance function" wasn't exact.
        // We can fix this by using a first-order Taylor series approximation for the true distance function.
        // (https://iquilezles.org/articles/distance)
        // Nevermind, there's something else at play here, too. Also, computing the gradient during the shadow step is expensive.
        // float dist = sdf / length(grad(pos, 0.01));
        float dist = sdf * 50.;
        res = min(res, 0.2 * dist/t);
        t += sdf;
        if (t >= light_dist || res < 0.001) break;
    }
    return res;
}

/*
float shadowcast_pointlight(in vec3 ro, in vec3 rd, in float light_dist){
    light_dist = min(light_dist, FAR_CLIP);
    float res = 1.f;
    float t = MIN_CLIP;
    float ph = 1e20;
    for (int i = 0; i < RAY_STEPS; i++){
        vec3 pos = ro + rd * t;
        float h = map(pos).x;
        
        float y = h*h/(2.*ph);
        float d = sqrt(h*h-y*y);
        res = min(res, 10.f * d/max(0., t-y));
        ph = h;
        t += h;

        if (res < 0.0001 || t > light_dist){
            break;
        }
    }
    return res;
}
*/

float shadowcast(in vec3 ro, in vec3 rd){
    return shadowcast_pointlight(ro, rd, FAR_CLIP);
}

float raycast(in vec3 ro, in vec3 rd, out vec2 mat){
    float t = MIN_CLIP;
    mat = vec2(-1, 0);
    for (int i = 0; i < RAY_STEPS; i++){
        vec3 pos = ro + rd * t;
        vec3 sdf = map(pos);
        float dist = sdf.x;
        mat = sdf.yz;
        if (abs(dist) < 0.0001f){
            return t;
        }
        if (t > FAR_CLIP){
            return -1.f;
        }
        t += dist;
    }
    return t;
}

vec3 calcmaterial(vec3 pos, vec3 nor, int mat){
        vec3 col = vec3(0.f);        
        
        // ambient light parameters
        vec3 sky_light = vec3(0.f, 0.1f, 0.3f) * clamp(0.5f + 0.5f * nor.y, 0.f, 1.f);
        
        // light parameters
        float aTime = iTime/2.f;
        #ifdef MOTION
        vec3 light_pos = vec3(7.f * sin(aTime) - iTime , 7.f, 7.f * cos(aTime));
        #else
        vec3 light_pos = vec3(7.f * sin(aTime) , 7.f, 7.f * cos(aTime));
        #endif
        vec3 light_dir = normalize(light_pos - pos);
        vec3 lambert_light = vec3(0.8f, 0.6f, 0.2f) * clamp(dot(nor, light_dir), 0.f, 1.f);
        //vec3 lambert_light = vec3(0.8f, 0.6f, 0.2f);

        #ifdef MOTION
        vec3 light2_pos = vec3(-7.f * cos(aTime) - iTime, 7.f, -7.f * sin(aTime));
        #else
        vec3 light2_pos = vec3(-7.f * cos(aTime), 7.f, -7.f * sin(aTime));
        #endif
        vec3 light2_dir = normalize(light2_pos - pos);
        vec3 lambert_light2 = vec3(0.8f, 0.2f, 0.01f) * clamp(dot(nor, light2_dir), 0.f, 1.f);
        //vec3 lambert_light2 =vec3(0.8f, 0.2f, 0.01f);
        

        // bounce light (fake GI)
        vec3 bounce_light = vec3(0.1f, 0.05f, 0.02f) * clamp(0.5f - 0.5f * nor.y, 0.f, 1.f);
        
        float light1_dist = distance(light_pos, pos);
        float light2_dist = distance(light2_pos, pos);
        // float t_shadow1 = shadowcast_pointlight(pos, light_dir, light1_dist) / (light1_dist*light1_dist);
        // float t_shadow2 = shadowcast_pointlight(pos, light2_dir, light2_dist) / (light2_dist*light2_dist);
        float t_shadow1 = shadowcast_pointlight(pos, light_dir, light1_dist);
        float t_shadow2 = shadowcast_pointlight(pos, light2_dir, light2_dist);
         //t_shadow = 1.f;
                
        vec3 base_colour;
        
        switch(mat){
            case WATER:
            base_colour = vec3(0.f, 0.1f, 0.3f) * 0.05f;
            break;
            case LAMBERT_RED:
            // vec2 textureIndex = mix(pos.xy, pos.xz, 0.5);
            // vec2 textureIndex = vec2(pos.x, pos.y+pos.z);
            // base_colour  = texture(iChannel0, textureIndex.xy/4.f).xyz;
            
            if (abs(nor.y) > abs(nor.z)){
                base_colour  = texture2D(iChannel0, pos.xz/4.f).xyz;
            } else {
                base_colour  = texture2D(iChannel0, pos.xy/4.f).xyz;
            }
            
            base_colour *= vec3(0.9f, 0.2f, 0.4f);
            break;
            case BLOB:
            base_colour = vec3(1.f, 0.4f, 0.3f);
            break;
        }
        
        // final colour evaluation
        vec3 sum_light = vec3(0);
        sum_light = lambert_light * t_shadow1 * 2.;
        sum_light += lambert_light2 * t_shadow2 * 2.;
        
        sum_light += sky_light;
        sum_light += bounce_light;
        
        return base_colour * sum_light;
        //return sum_light;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized device coordinates (from -1 to 1)
    vec2 uv = fragCoord/iResolution.xy;
    vec2 ndc = vec2((2.f * uv.x) - 1.f, 1.f - (2.f * uv.y)); 
    
    
    // camera variance variable
    #ifdef MOUSE_CONTROL
    float u = 20.f * iMouse.x/iResolution.x;
    float v = PI/2.f * iMouse.y/iResolution.y;
    #endif
    
    // Camera parameters
    #ifdef MOUSE_CONTROL
    float d = 20.f;
    float aTime = iTime/2.f;
    vec3 eye = vec3(d * cos(u), 30.f * abs(sin(v)), d * sin(u));
    vec3 ref = vec3(0.f, 0.f, 0.f);
    #endif
    
    #ifdef VIEW_0
    float d = 20.f;
    float aTime = iTime/2.f;
    vec3 eye = vec3(d, 7.5f, 0.f);
    vec3 ref = vec3(0.f, 0.f, 0.f);
    #endif
    
    #ifdef VIEW_1
    float d = 20.f;
    float aTime = iTime/2.f;
    vec3 eye = vec3(0.f, 5.f, d);
    vec3 ref = vec3(0.f, 0.f, 0.f);
    #endif
    
    #ifdef MOTION
    #ifndef VIEW_1
    vec3 motion = vec3(-iTime, abs(sin(iTime)), 0.f);
    #else
    vec3 motion = vec3(-iTime, 0.f, 0.f);
    #endif
    eye += motion;
    ref.x += motion.x;
    #endif
    float fov = 45.f;
    
    vec3 ro , rd;
    computeray(eye, ref, ndc, fov, ro, rd);
        
    #ifdef DISTANCE_FOG
    vec3 skyCol = mix(vec3(0.f, 0.1f, 0.3f) * 0.3f, vec3(0.f, 0.1f, 0.3f) * 0.f, abs(ndc.y * 1.25f));     
    #else
    vec3 skyCol = vec3(0.f);
    #endif
    vec3 col = skyCol;
    vec2 mat = vec2(-1.f, 0.f);
    float t = raycast(ro, rd, mat);
    
    // TODO: Clean this up to handle the water more nicely. (With less duplicated logic.)
    if (t > 0.f){
        vec3 pos = ro + t * rd;
        
        vec3 initialNorm = calcNormal(pos, 0.01f);
        vec3 initialCol = calcmaterial(pos, initialNorm, int(round(mat.x)));    
        // Add a water reflection. Blend it using the water mask stored in mat.y.
        if (mat.y > 0.){
            vec3 ro_new = pos;
            vec3 rd_new = reflect(rd, initialNorm);
            vec2 mat_new;
            float t_new = raycast(ro_new, rd_new, mat_new);
            
            vec3 reflectedCol;
            if (t_new > 0.) {
                // pos = ro_new + t_new*rd_new;
                // t = min(t + t_new, FAR_CLIP);
                // mat = mat_new;
                vec3 pos_new = ro_new + t_new*rd_new;
                
                vec3 reflectedNorm = calcNormal(pos_new, 0.01f);
                reflectedCol = calcmaterial(pos_new, reflectedNorm, int(round(mat_new.x)));
                // reflectedCol = calcmaterial(pos_new, reflectedNorm, BLOB);
            } else {
                // TODO: This is probably wrong, since the sky is non-uniform.
                reflectedCol = skyCol;
            }
            reflectedCol *= 0.35; // Dampen the water reflection.
            col = mix(initialCol, reflectedCol, mat.y);
        } else {
            col = initialCol;
        }
        // TODO: Apply these separately to initialCol and reflectedCol.
        col *= 1.f - pow(t/FAR_CLIP, 2.f) * vec3(0.8f, 0.8f, 0.6f);
        #ifdef DISTANCE_FOG
        col += vec3(0.f, 0.1f, 0.3f) * 0.25f * (t/FAR_CLIP) * (t/FAR_CLIP) ;
        #endif
    }
    
    #ifdef GAMMA_CORRECTION
    // Gamma correction - https://www.youtube.com/watch?v=Cfe5UQ-1L9Q&t=1990s - 38:00
    col = pow(col, vec3(0.4545f));
    #endif
    
    // Output to screen
    fragColor = vec4(col,t);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

